<#assign licenseFirst = "/*">
<#assign licensePrefix = " * ">
<#assign licenseLast = " */">
<#include "${project.licensePath}">

<#if package?? && package != "">
package ${package};

</#if>
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RequestMapping;
<#if crudMethods>
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
</#if>
<#switch errorHandling>
  <#case 1>
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
  <#break>
  <#case 2>
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
    <#if !crudMethods>
import reactor.core.publisher.Mono;
    </#if>
  <#break>
</#switch>

@RestController
@RequestMapping("/url")
public class ${name}
{
<#if crudMethods>

    @GetMapping()
    public Flux<Object> list()
	{
        return null;
    }

    @GetMapping("/{id}")
    public Mono<Object> get(@PathVariable String id)
	{
        return null;
    }

    @PutMapping("/{id}")
    public Mono<ResponseEntity<?>> put(@PathVariable String id, @RequestBody Object input)
	{
        return null;
    }

    @PostMapping
    public Mono<ResponseEntity<?>> post(@RequestBody Object input)
	{
        return null;
    }

    @DeleteMapping("/{id}")
    public Mono<ResponseEntity<?>> delete(@PathVariable String id)
	{
        return null;
    }
</#if>
<#switch errorHandling>
  <#case 1>

    @ExceptionHandler(Exception.class)
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR, reason="Error message")
    public void handleError()
	{
    }
  <#break>
  <#case 2>

    @ExceptionHandler(Exception.class)
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR, reason="Error message")
    public Mono<Object> handleError(Exception ex)
	{
		Object errorObject=new Object();
		return Mono.just(errorObject);
    }
  <#break>
</#switch>
}